import React from "react";
import { useState } from "react";
import moment from "moment";
import TraingleIcon from "../../../svg/triangle";
import MessageMenu from "./MessageMenu";

export default function Message({ message, me }) {
  const [showMenu, setShowMenu] = useState(false);

  const handleRightClick = (e) => {
    e.preventDefault();
    setShowMenu(true);
  };

  const handleCloseMenu = () => {
    setShowMenu(false);
  };

  return (
    <div
      className={`w-full flex mt-2 space-x-3 max-w-xs ${
        me ? "ml-auto justify-end " : ""
      }`}
      onContextMenu={handleRightClick}
    >
      {/*Message Container*/}
      <div className="relative">
        {/* sender user message */}
        {!me && message.conversation.isGroup && (
          <div className="absolute top-0.5 left-[-37px]">
            <img
              src={message.sender.picture}
              alt=""
              className="w-8 h-8 rounded-full"
            />
          </div>
        )}
        <div
          className={`relative h-full dark:text-dark_text_1 p-2 rounded-lg cursor-pointer hover:shadow-lg transition-shadow
        ${me ? "bg-green_3" : "dark:bg-dark_bg_2"}
        `}
        >
          {/*Message*/}
          <p className="float-left h-full text-sm pb-4 pr-8">
            {message.message}
          </p>
          {/*Message Date*/}
          <span className="absolute right-1.5 bottom-1.5 text-xs text-dark_text_5 leading-none">
            {moment(message.createdAt).format("HH:mm")}
          </span>
          {/*Traingle*/}
          {!me ? (
            <span>
              <TraingleIcon className="dark:fill-dark_bg_2 rotate-[60deg] absolute top-[-5px] -left-1.5" />
            </span>
          ) : null}
        </div>
        
        {/* Message Menu */}
        {showMenu && (
          <MessageMenu 
            message={message} 
            me={me} 
            onClose={handleCloseMenu}
          />
        )}
      </div>
    </div>
  );
}
